#!/usr/bin/env python3
import hashlib
from Cryptodome.Cipher import AES

# --- CONFIGURATION ---
CIPHERTEXT_BIN_FILE = "backup.enc"   # ⚠️ Fichier binaire de 32 octets
WORDLIST = "/usr/share/SecLists-master/Passwords/rockyou.txt"
# --------------------

# Charger les 32 octets bruts
with open(CIPHERTEXT_BIN_FILE, "rb") as f:
    ciphertext = f.read()

if len(ciphertext) != 32:
    raise ValueError(f"Erreur : le fichier doit faire 32 octets, pas {len(ciphertext)}")

print("[+] Chiffré binaire chargé (32 octets)")

def decrypt_with_password(password: str) -> bytes | None:
    try:
        # Clé : SHA256(password) en binaire (32 bytes)
        key = hashlib.sha256(password.encode()).digest()
        
        # IV : hash('sha256', 'iv' . $password) → hexdigest → 16 premiers caractères → encode en ASCII (16 bytes)
        iv_hex = hashlib.sha256(("iv" + password).encode()).hexdigest()[:16]
        iv = iv_hex.encode('ascii')  # Important : ce sont des bytes ASCII comme b'abcd1234...'

        cipher = AES.new(key, AES.MODE_CBC, iv)
        return cipher.decrypt(ciphertext)
    except:
        return None

# Brute-force
with open(WORDLIST, "r", encoding="latin-1", errors="ignore") as f:
    for i, line in enumerate(f, 1):
        pwd = line.strip()
        if not pwd:
            continue

        plaintext = decrypt_with_password(pwd)
        if plaintext and b"FLAG{" in plaintext:
            # On a trouvé ! Essaye d'afficher proprement
            try:
                # Supprime padding PKCS#7 si valide
                pad = plaintext[-1]
                if 1 <= pad <= 16 and plaintext[-pad:] == bytes([pad]) * pad:
                    plaintext = plaintext[:-pad]
                flag = plaintext.decode('utf-8', errors='replace')
                print(f"\n🎉 Mot de passe trouvé : '{pwd}'")
                print(f"Flag : {flag}")
                exit(0)
            except:
                print(f"\n⚠️  Mot de passe : '{pwd}' → données brutes : {plaintext}")
                exit(0)

        if i % 50000 == 0:
            print(f"[{i}] Testé : {pwd[:30]}")

print("\n❌ Aucun mot de passe dans rockyou.txt ne produit un flag.")
